/*
 * Decompiled with CFR 0.152.
 */
package ru.kirillius.FFMPEG4J;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import ru.kirillius.FFMPEG4J.FFMPEGException;
import ru.kirillius.FFMPEG4J.ProcessConfiguration;

public final class ProcessFactory {
    private static final ProcessFactory instance = new ProcessFactory();
    private final File ffmpegPath;
    private final File ffprobePath;

    private ProcessFactory() {
        try {
            this.ffmpegPath = ProcessFactory.findProgram("ffmpeg");
            this.ffprobePath = ProcessFactory.findProgram("ffprobe");
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static File findProgram(String name) throws IOException, InterruptedException, FFMPEGException {
        String OS = System.getProperty("os.name");
        String finder = OS.toLowerCase().contains("windows") ? "where" : "which";
        Process finderProcess = Runtime.getRuntime().exec(finder + " " + name);
        BufferedReader consoleOutput = new BufferedReader(new InputStreamReader(finderProcess.getInputStream()));
        finderProcess.waitFor();
        File path = null;
        if (finderProcess.exitValue() == 0) {
            path = new File(consoleOutput.readLine());
            if (!path.exists()) {
                throw new FFMPEGException("Path to " + name + " is not accessible: " + path);
            }
        } else {
            String line;
            StringBuilder textualOutput = new StringBuilder();
            while ((line = consoleOutput.readLine()) != null) {
                textualOutput.append(line).append("\r\n");
            }
            throw new FFMPEGException(textualOutput.toString());
        }
        return path;
    }

    public static ProcessFactory getInstance() {
        return instance;
    }

    public Process createProcess(ProcessConfiguration configuration) throws IOException {
        List<String> args = configuration.getArguments();
        String[] cmdarray = new String[args.size() + 1];
        cmdarray[0] = this.ffmpegPath.getPath();
        int i = 1;
        for (String s : args) {
            cmdarray[i++] = s;
        }
        return Runtime.getRuntime().exec(cmdarray);
    }

    public Process createProbe(String input) throws IOException {
        String[] cmd = new String[]{this.ffprobePath.getPath(), "-hide_banner", input};
        return Runtime.getRuntime().exec(cmd);
    }
}

