/*
 * Decompiled with CFR 0.152.
 */
package ru.kirillius.FFMPEG4J;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringJoiner;
import ru.kirillius.FFMPEG4J.LoggerAdapterInterface;
import ru.kirillius.FFMPEG4J.ProcessConfiguration;
import ru.kirillius.FFMPEG4J.ProcessFactory;
import ru.kirillius.FFMPEG4J.ProcessInfoParser;

public final class ProcessController {
    private ProcessConfiguration configuration;
    private Process processHandler = null;
    private ProcessInfoParser processInfoParser = null;
    private LoggerAdapterInterface loggerAdapter = null;
    private Thread infoParserThread = null;
    private volatile Status status = Status.INITIATED;

    public long getPID() {
        if (this.processHandler == null) {
            return -1L;
        }
        return this.processHandler.pid();
    }

    public Process getProcessHandler() {
        return this.processHandler;
    }

    public void setLoggerAdapter(LoggerAdapterInterface loggerAdapter) {
        this.loggerAdapter = loggerAdapter;
    }

    public String getProcessStartupArguments() {
        StringJoiner joiner = new StringJoiner(" ");
        for (String argument : this.configuration.getArguments()) {
            joiner.add(argument);
        }
        return joiner.toString();
    }

    public ProcessController(ProcessConfiguration configuration) {
        this.configuration = configuration;
    }

    public void start() {
        if (this.status != Status.STARTING && this.status != Status.RUNNING) {
            this.status = Status.STARTING;
            try {
                this.processHandler = ProcessFactory.getInstance().createProcess(this.configuration);
                if (this.loggerAdapter != null) {
                    this.loggerAdapter.printMessage("Starting process with arguments " + this.getProcessStartupArguments());
                }
                if (this.configuration.hasInfoParser()) {
                    this.processInfoParser = new ProcessInfoParser(new BufferedReader(new InputStreamReader(this.processHandler.getErrorStream())), this.loggerAdapter);
                    this.processInfoParser.setDeadTimer(this.configuration.getDeadTimer());
                    this.processInfoParser.setWarmUpTimer(this.configuration.getWarmUpTimer());
                    this.infoParserThread = new Thread(() -> {
                        while (!Thread.interrupted()) {
                            try {
                                Thread.sleep(50L);
                                this.processInfoParser.read();
                            }
                            catch (IOException | InterruptedException e) {
                                break;
                            }
                        }
                    });
                    this.infoParserThread.start();
                }
                this.status = Status.RUNNING;
            }
            catch (IOException e) {
                e.printStackTrace();
                this.status = Status.DEAD;
            }
        } else {
            throw new IllegalStateException("Process is started already");
        }
    }

    public Status getStatus() {
        this.readProcessStatus();
        return this.status;
    }

    public void stop() {
        if (this.infoParserThread != null) {
            this.infoParserThread.interrupt();
        }
        if (this.status != Status.RUNNING) {
            throw new IllegalStateException("Process is not running");
        }
        this.status = Status.STOPPED;
        if (this.processHandler != null) {
            this.processHandler.destroyForcibly();
        }
    }

    private void readProcessStatus() {
        if (this.status == Status.RUNNING) {
            if (this.processHandler.isAlive()) {
                if (this.configuration.hasInfoParser() && !this.processInfoParser.isStreamAlive()) {
                    this.stop();
                    this.status = Status.DEAD;
                }
            } else {
                this.stop();
                this.status = Status.DEAD;
            }
        }
    }

    public boolean isAlive() {
        this.readProcessStatus();
        return this.status != Status.STOPPED && this.status != Status.DEAD;
    }

    public static enum Status {
        INITIATED,
        STARTING,
        RUNNING,
        STOPPED,
        DEAD;

    }
}

