/*
 * Decompiled with CFR 0.152.
 */
package ru.kirillius.FFMPEG4J;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import ru.kirillius.FFMPEG4J.StreamInfo;

public final class InputInfo {
    private int programNumber = 0;
    private String serviceName = "Unknown";
    private String serviceProvider = "Unknown";
    private List<StreamInfo> streams = new ArrayList<StreamInfo>();
    private String format = "Unknown";

    public String getFormat() {
        return this.format;
    }

    public String toString() {
        return "InputInfo{programNumber=" + this.programNumber + ", serviceName='" + this.serviceName + "', serviceProvider='" + this.serviceProvider + "', streams=" + this.streams + ", format='" + this.format + "'}";
    }

    public int getProgramNumber() {
        return this.programNumber;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServiceProvider() {
        return this.serviceProvider;
    }

    public Collection<StreamInfo> getStreams() {
        return List.copyOf(this.streams);
    }

    private InputInfo() {
    }

    public static Builder create() {
        return new InputInfo().new Builder();
    }

    public class Builder {
        private Builder() {
        }

        public Builder setProgramNumber(int programNumber) {
            InputInfo.this.programNumber = programNumber;
            return this;
        }

        public Builder setFormat(String format) {
            InputInfo.this.format = format;
            return this;
        }

        public Builder setServiceName(String serviceName) {
            InputInfo.this.serviceName = serviceName;
            return this;
        }

        public Builder setServiceProvider(String serviceProvider) {
            InputInfo.this.serviceProvider = serviceProvider;
            return this;
        }

        public Builder addStream(StreamInfo stream) {
            InputInfo.this.streams.add(stream);
            return this;
        }

        public InputInfo build() {
            return InputInfo.this;
        }
    }
}

