/*
 * Decompiled with CFR 0.152.
 */
package ru.kirillius.FFMPEG4J;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import ru.kirillius.FFMPEG4J.CodecDescription;
import ru.kirillius.FFMPEG4J.FFMPEGException;
import ru.kirillius.FFMPEG4J.FormatDescription;
import ru.kirillius.FFMPEG4J.InputInfo;
import ru.kirillius.FFMPEG4J.ProcessConfiguration;
import ru.kirillius.FFMPEG4J.ProcessFactory;
import ru.kirillius.FFMPEG4J.StreamInfo;

public final class FFMPEGUtil {
    private FFMPEGUtil() {
    }

    public static List<CodecDescription> getSupportedCodecs() throws FFMPEGException {
        ArrayList<CodecDescription> codecs = new ArrayList<CodecDescription>();
        Process process = null;
        try {
            process = ProcessFactory.getInstance().createProcess(ProcessConfiguration.build("-codecs"));
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                while (process.isAlive()) {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        line = line.trim();
                        while (line.contains("  ")) {
                            line = line.replace("  ", " ");
                        }
                        String[] split = line.split(" ", 3);
                        if (split.length < 3) continue;
                        codecs.add(new CodecDescription(split[1], split[2], split[0]));
                    }
                }
            }
        }
        catch (IOException e) {
            throw new FFMPEGException("Failed to get supported codec list", e);
        }
        return codecs;
    }

    public static List<FormatDescription> getSupportedFormats() throws FFMPEGException {
        ArrayList<FormatDescription> formats = new ArrayList<FormatDescription>();
        Process process = null;
        try {
            process = ProcessFactory.getInstance().createProcess(ProcessConfiguration.build("-formats"));
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                while (process.isAlive()) {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        String[] formatNames;
                        line = line.trim();
                        while (line.contains("  ")) {
                            line = line.replace("  ", " ");
                        }
                        String[] split = line.split(" ", 3);
                        if (split.length < 3) continue;
                        for (String formatName : formatNames = split[1].split(",")) {
                            boolean found = false;
                            for (FormatDescription format : formats) {
                                if (!format.getName().equals(formatName)) continue;
                                found = true;
                                format.updateFlags(split[0]);
                            }
                            if (found) continue;
                            formats.add(new FormatDescription(split[1], split[2], split[0]));
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            throw new FFMPEGException("Failed to get supported format list", e);
        }
        return formats;
    }

    public static InputInfo probeInput(String input, long timeout) throws FFMPEGException {
        Object info = null;
        try {
            ProbeTask task = new ProbeTask(input);
            task.start();
            long timeTaken = 0L;
            do {
                Thread.sleep(1000L);
            } while ((timeTaken += 1000L) < timeout && !task.isDone());
            if (timeTaken >= timeout) {
                task.destroy();
            }
            return task.getInfo();
        }
        catch (Exception e) {
            throw new FFMPEGException("Failed to probe input", e);
        }
    }

    private static final class ProbeTask
    extends Thread {
        private final Process probe;
        private volatile boolean done = false;
        private InputInfo info = null;

        public ProbeTask(String input) throws IOException {
            this.probe = ProcessFactory.getInstance().createProbe(input);
        }

        public InputInfo getInfo() {
            return this.info;
        }

        public void destroy() {
            this.interrupt();
            this.probe.destroyForcibly();
        }

        @Override
        public void run() {
            InputInfo.Builder ib = InputInfo.create();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.probe.getErrorStream()));){
                while (this.probe.isAlive()) {
                    String l;
                    while ((l = reader.readLine()) != null) {
                        int pos;
                        String[] split;
                        if ((l = l.trim()).startsWith("Input #0")) {
                            split = l.split(",");
                            ib.setFormat(split[1].trim());
                        }
                        if (l.startsWith("Program")) {
                            split = l.split(" ");
                            ib.setProgramNumber(Integer.parseInt(split[1]));
                        }
                        if (l.startsWith("service_name")) {
                            split = l.split(":");
                            ib.setServiceName(split[1]);
                        }
                        if (l.startsWith("service_provider")) {
                            split = l.split(":");
                            ib.setServiceProvider(split[1]);
                        }
                        if (!l.startsWith("Stream")) continue;
                        split = l.split(":", 4);
                        String pids = split[1];
                        int ppos = pids.indexOf("0x");
                        int epos = pids.lastIndexOf("]");
                        int pid = 0;
                        if (epos > 0) {
                            pid = Integer.parseInt(pids.substring(ppos + 2, epos));
                        }
                        String type = split[2].trim();
                        split = split[3].trim().split(" ");
                        String codec = split[0].trim();
                        StreamInfo.Builder sb = StreamInfo.create(pid, type, codec);
                        for (String part : l.split(",")) {
                            if (!part.contains("SAR")) continue;
                            pos = part.indexOf(91);
                            part = part.substring(0, pos).trim();
                            String[] xes = part.split("x");
                            sb.setResolution(Integer.parseInt(xes[0]), Integer.parseInt(xes[1]));
                        }
                        for (String part : l.split(",")) {
                            pos = part.indexOf("fps");
                            if (pos <= 0) continue;
                            part = part.substring(0, pos).trim();
                            sb.setFPS(Integer.parseInt(part));
                        }
                        ib.addStream(sb.build());
                    }
                }
                this.info = ib.build();
                this.done = true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public boolean isDone() {
            return this.done;
        }
    }
}

