/*
 * Decompiled with CFR 0.152.
 */
package ru.kirillius.compiler;

import java.util.Map;
import java.util.Objects;
import ru.kirillius.compiler.CompiledFileBytecode;
import ru.kirillius.compiler.RuntimeFileManager;

public class RuntimeClassLoader
extends ClassLoader {
    private final RuntimeFileManager manager;

    public RuntimeClassLoader(ClassLoader parent, RuntimeFileManager manager) {
        super(parent);
        this.manager = Objects.requireNonNull(manager, "manager must not be null");
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Map<String, CompiledFileBytecode> compiledClasses = this.manager.getClasses();
        if (compiledClasses.containsKey(name)) {
            byte[] bytes = compiledClasses.get(name).asByteArray();
            return this.defineClass(name, bytes, 0, bytes.length);
        }
        throw new ClassNotFoundException();
    }
}

